/*
 * Decompiled with CFR 0.152.
 */
package FaceDetect;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.MimetypesFileTypeMap;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfRect;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.highgui.Highgui;
import org.opencv.highgui.VideoCapture;
import org.opencv.imgproc.Imgproc;
import org.opencv.objdetect.CascadeClassifier;

public class JavaFaceDetect
extends JFrame {
    final String uriString = "http://www.power-bits.de";
    private boolean faceDetectCbx = false;
    private boolean eyesDetectCbx = false;
    private boolean mouthDetectCbx = false;
    private boolean smileDetectCbx = false;
    private boolean sourceVideo = false;
    private boolean sourcePicture = false;
    private boolean runApp = false;
    private DaemonThread myThread = null;
    private String usrDir;
    private CascadeClassifier faceDetector = new CascadeClassifier();
    private CascadeClassifier eyeDetector = new CascadeClassifier();
    private CascadeClassifier mouthDetector = new CascadeClassifier();
    private CascadeClassifier smileDetector = new CascadeClassifier();
    private String faceStr = "\\CascadeFiles\\haarcascade_frontalface_alt_tree.xml";
    private String eyeStr = "\\CascadeFiles\\haarcascade_eye.xml";
    private String mouthStr = "\\CascadeFiles\\haarcascade_mcs_mouth.xml";
    private String smileStr = "\\CascadeFiles\\haarcascade_smile.xml";
    private String videoFilePath = "";
    private String videoFileExt = "";
    private int count = 0;
    private int cameraIdx = 0;
    private int maxCameras = 0;
    private int textX;
    private int textY;
    private VideoCapture camSource = null;
    private String cascadePath;
    private Mat frame = new Mat();
    private Mat mGrayFrame = new Mat();
    private MatOfByte mem = new MatOfByte();
    private MatOfRect faceDetections;
    private Mat matFaceEyeDetection;
    private Mat matFaceMouthDetection;
    private Rect[] facerect;
    private Rect[] smileRect;
    private int halfFaceRoi;
    private JButton btnCascadePath;
    private JButton btnStart;
    private JButton btnStop;
    private JButton btnVideoFile;
    private JComboBox<String> cbbCameras;
    private JCheckBox cbxEyesDetect;
    private JCheckBox cbxFaceDetect;
    private JCheckBox cbxMouthDetect;
    private JCheckBox cbxSmileDetect;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel labelUrl;
    private JLabel lblCamera;
    private JLabel lblMessage;

    /*
     * WARNING - void declaration
     */
    private void detectAndDraw() {
        block16: {
            boolean bl = false;
            boolean bl2 = false;
            try {
                Object object;
                if (!this.sourcePicture) {
                    this.camSource.read(this.frame);
                }
                Imgproc.cvtColor(this.frame, this.mGrayFrame, 7);
                if (this.faceDetectCbx || this.eyesDetectCbx || this.mouthDetectCbx || this.smileDetectCbx) {
                    int n;
                    int n2;
                    this.faceDetections = new MatOfRect();
                    this.faceDetector.detectMultiScale(this.mGrayFrame, this.faceDetections);
                    if (this.faceDetectCbx) {
                        for (Rect rectArray : this.faceDetections.toArray()) {
                            Core.rectangle(this.frame, new Point(rectArray.x, rectArray.y), new Point(rectArray.x + rectArray.width, rectArray.y + rectArray.height), new Scalar(0.0, 255.0, 0.0), 2);
                        }
                    }
                    this.facerect = this.faceDetections.toArray();
                    this.textX = this.facerect[0].x;
                    this.textY = this.facerect[0].y - 10;
                    if (this.facerect[0].width - this.facerect[0].y < 100 && !this.sourceVideo && !this.sourcePicture) {
                        Core.putText(this.frame, "move closer to camera!", new Point(this.textX, this.textY), 0, 0.5, new Scalar(0.0, 255.0, 0.0), 2);
                    }
                    this.facerect[0].height /= 2;
                    this.matFaceEyeDetection = this.mGrayFrame.submat(this.facerect[0]);
                    this.facerect[0].height *= 2;
                    this.facerect[0].height /= 3;
                    this.halfFaceRoi = this.facerect[0].height * 2;
                    this.facerect[0].y += this.facerect[0].height * 2;
                    this.matFaceMouthDetection = this.mGrayFrame.submat(this.facerect[0]);
                    this.facerect[0].y -= this.facerect[0].height * 2;
                    this.facerect[0].height *= 3;
                    if (this.eyesDetectCbx) {
                        object = new MatOfRect();
                        this.eyeDetector.detectMultiScale(this.matFaceEyeDetection, (MatOfRect)object);
                        Point point = new Point();
                        for (Rect rect : ((MatOfRect)object).toArray()) {
                            point.x = rect.x + this.facerect[0].x + rect.width / 2;
                            point.y = rect.y + this.facerect[0].y + rect.height / 2;
                            n2 = (rect.width + rect.height) / 4;
                            Core.circle(this.frame, point, n2, new Scalar(0.0, 0.0, 255.0), 2);
                        }
                    }
                    if (this.mouthDetectCbx) {
                        void var6_16;
                        object = new MatOfRect();
                        this.mouthDetector.detectMultiScale(this.matFaceMouthDetection, (MatOfRect)object);
                        Rect[] rectArray = ((MatOfRect)object).toArray();
                        n2 = rectArray.length;
                        boolean bl3 = false;
                        while (var6_16 < n2) {
                            Rect rect = rectArray[var6_16];
                            n = rect.x + this.facerect[0].x;
                            int n3 = rect.y + this.facerect[0].y + this.halfFaceRoi;
                            Core.rectangle(this.frame, new Point(n, n3), new Point(n + rect.width, n3 + rect.height), new Scalar(0.0, 255.0, 255.0), 2);
                            ++var6_16;
                        }
                    }
                    if (this.smileDetectCbx) {
                        void var6_18;
                        object = new MatOfRect();
                        this.mouthDetector.detectMultiScale(this.matFaceMouthDetection, (MatOfRect)object);
                        Rect[] rectArray = ((MatOfRect)object).toArray();
                        n2 = rectArray.length;
                        boolean bl4 = false;
                        while (var6_18 < n2) {
                            Rect rect = rectArray[var6_18];
                            n = rect.x + this.facerect[0].x;
                            int n4 = rect.y + this.facerect[0].y + this.halfFaceRoi;
                            System.out.println("smile: " + ((MatOfRect)object).toArray().length);
                            if (((MatOfRect)object).toArray().length > 2) {
                                this.lblMessage.setText("     smile detect");
                                Core.rectangle(this.frame, new Point(n, n4), new Point(n + rect.width, n4 + rect.height), new Scalar(255.0, 0.0, 255.0), 2);
                            } else {
                                this.lblMessage.setText("");
                            }
                            ++var6_18;
                        }
                    }
                }
                Highgui.imencode(".bmp", this.frame, this.mem);
                object = ImageIO.read(new ByteArrayInputStream(this.mem.toArray()));
                BufferedImage bufferedImage = (BufferedImage)object;
                Graphics graphics = this.jPanel1.getGraphics();
                if (graphics.drawImage(bufferedImage, 0, 0, this.getWidth(), this.getHeight() - 150, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null) && !this.runApp) {
                    System.out.println("Going to wait()");
                    this.wait();
                }
            }
            catch (Exception exception) {
                System.out.println("Error grab Image");
                if (!this.smileDetectCbx) break block16;
                this.lblMessage.setText("Error grab Image");
            }
        }
    }

    private static void urlOpen(URI uRI) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(uRI);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void detectNumAttachedCvCameras() {
        this.maxCameras = 0;
        while (true) {
            this.camSource.open(this.maxCameras);
            if (!this.camSource.isOpened()) break;
            this.cbbCameras.addItem(" " + (this.maxCameras + 1) + " ");
            ++this.maxCameras;
            this.camSource.release();
        }
    }

    public boolean readFile() {
        FileReader fileReader = null;
        boolean bl = false;
        String string = new String();
        try {
            fileReader = new FileReader(this.usrDir + "\\mdt.cfg");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            this.cascadePath = bufferedReader.readLine();
            fileReader.close();
            bl = true;
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
            bl = false;
        }
        System.out.println(bl + " " + string);
        return bl;
    }

    public boolean writeFile() {
        FileWriter fileWriter = null;
        boolean bl = false;
        String string = new String();
        try {
            fileWriter = new FileWriter(this.usrDir + "\\mdt.cfg", false);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.print(this.cascadePath);
            fileWriter.close();
            bl = true;
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
            bl = false;
        }
        System.out.println(bl + " " + string);
        return bl;
    }

    public JavaFaceDetect() {
        this.initComponents();
        this.usrDir = System.getProperty("user.dir");
        boolean bl = this.readFile();
        if (!bl) {
            this.lblMessage.setText(this.usrDir + "  no cfg file found");
        } else {
            System.out.println(this.cascadePath);
            this.lblMessage.setText(this.cascadePath + "  found Cascade files");
            this.faceStr = this.cascadePath + "/haarcascade_frontalface_alt_tree.xml";
            this.eyeStr = this.cascadePath + "/haarcascade_eye.xml";
            this.mouthStr = this.cascadePath + "/haarcascade_mcs_mouth.xml";
            this.smileStr = this.cascadePath + "/haarcascade_smile.xml";
            this.btnStart.setEnabled(true);
        }
        this.camSource = new VideoCapture();
        this.detectNumAttachedCvCameras();
        if (this.maxCameras == 0) {
            this.lblCamera.setText("no camera found");
            this.btnStart.setEnabled(false);
        } else {
            this.camSource.open(this.cameraIdx);
            this.lblCamera.setText("using camera:");
            this.sourceVideo = false;
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.btnStart = new JButton();
        this.btnStop = new JButton();
        this.cbxFaceDetect = new JCheckBox();
        this.cbxEyesDetect = new JCheckBox();
        this.cbxMouthDetect = new JCheckBox();
        this.cbxSmileDetect = new JCheckBox();
        this.lblMessage = new JLabel();
        this.btnCascadePath = new JButton();
        this.labelUrl = new JLabel();
        this.lblCamera = new JLabel();
        this.cbbCameras = new JComboBox();
        this.btnVideoFile = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("OpenCV Face Recognizer by Heinrich Voggenreiter");
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setPreferredSize(new Dimension(640, 480));
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 638, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 476, Short.MAX_VALUE));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.btnStart.setFont(new Font("Tahoma", 1, 14));
        this.btnStart.setText("Start");
        this.btnStart.setEnabled(false);
        this.btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaFaceDetect.this.btnStartActionPerformed(actionEvent);
            }
        });
        this.btnStop.setFont(new Font("Tahoma", 1, 14));
        this.btnStop.setText("Stop");
        this.btnStop.setEnabled(false);
        this.btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaFaceDetect.this.btnStopActionPerformed(actionEvent);
            }
        });
        this.cbxFaceDetect.setFont(new Font("Tahoma", 1, 14));
        this.cbxFaceDetect.setText("Face Detect");
        this.cbxFaceDetect.setEnabled(false);
        this.cbxFaceDetect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaFaceDetect.this.cbxFaceDetectActionPerformed(actionEvent);
            }
        });
        this.cbxEyesDetect.setFont(new Font("Tahoma", 1, 14));
        this.cbxEyesDetect.setText("Eyes Detect");
        this.cbxEyesDetect.setEnabled(false);
        this.cbxEyesDetect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaFaceDetect.this.cbxEyesDetectActionPerformed(actionEvent);
            }
        });
        this.cbxMouthDetect.setFont(new Font("Tahoma", 1, 14));
        this.cbxMouthDetect.setText("Mouth Detect");
        this.cbxMouthDetect.setEnabled(false);
        this.cbxMouthDetect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaFaceDetect.this.cbxMouthDetectActionPerformed(actionEvent);
            }
        });
        this.cbxSmileDetect.setFont(new Font("Tahoma", 1, 14));
        this.cbxSmileDetect.setText("Smile Detect");
        this.cbxSmileDetect.setEnabled(false);
        this.cbxSmileDetect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaFaceDetect.this.cbxSmileDetectActionPerformed(actionEvent);
            }
        });
        this.lblMessage.setFont(new Font("Tahoma", 1, 14));
        this.btnCascadePath.setFont(new Font("Tahoma", 1, 12));
        this.btnCascadePath.setText("Cascade Path");
        this.btnCascadePath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaFaceDetect.this.btnCascadePathActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(21, 21, 21).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.cbxFaceDetect).addGap(33, 33, 33).addComponent(this.cbxEyesDetect)).addGroup(groupLayout2.createSequentialGroup().addComponent(this.cbxMouthDetect).addGap(18, 18, 18).addComponent(this.cbxSmileDetect))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnCascadePath, -2, 130, -2).addGap(38, 38, 38).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnStart, GroupLayout.Alignment.TRAILING).addComponent(this.btnStop, GroupLayout.Alignment.TRAILING)).addGap(30, 30, 30)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.lblMessage, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbxFaceDetect).addComponent(this.cbxEyesDetect)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbxMouthDetect).addComponent(this.cbxSmileDetect)).addGap(0, 0, Short.MAX_VALUE)).addGroup(groupLayout2.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnStart).addComponent(this.btnCascadePath)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnStop).addGap(8, 8, 8).addComponent(this.lblMessage, -2, 15, -2))).addContainerGap()));
        this.labelUrl.setFont(new Font("Tahoma", 1, 14));
        this.labelUrl.setText("<HTML><FONT color=\\\"#000099\\\"><U>www.power-bits.de</U></FONT></HTML>");
        this.labelUrl.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                JavaFaceDetect.this.labelUrlMouseMoved(mouseEvent);
            }
        });
        this.labelUrl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JavaFaceDetect.this.labelUrlMouseClicked(mouseEvent);
            }
        });
        this.lblCamera.setFont(new Font("Tahoma", 1, 14));
        this.lblCamera.setText("using camera:");
        this.lblCamera.setHorizontalTextPosition(0);
        this.cbbCameras.setFont(new Font("Tahoma", 1, 14));
        this.cbbCameras.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaFaceDetect.this.cbbCamerasActionPerformed(actionEvent);
            }
        });
        this.btnVideoFile.setFont(new Font("Tahoma", 1, 14));
        this.btnVideoFile.setText("Video File...");
        this.btnVideoFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaFaceDetect.this.btnVideoFileActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout3 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanel1, -2, 642, -2)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(groupLayout3.createSequentialGroup().addGap(103, 103, 103).addComponent(this.labelUrl, -2, -1, -2).addGap(29, 29, 29).addComponent(this.lblCamera, -2, 125, -2).addGap(18, 18, 18).addComponent(this.cbbCameras, -2, -1, -2).addGap(37, 37, 37).addComponent(this.btnVideoFile).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout3.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.labelUrl, -2, 15, -2)).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jPanel2, -2, 110, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCamera, GroupLayout.Alignment.TRAILING, -2, 15, -2).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbbCameras, -2, -1, -2).addComponent(this.btnVideoFile))))).addGap(15, 15, 15)));
        this.pack();
    }

    private void btnStartActionPerformed(ActionEvent actionEvent) {
        if (this.sourceVideo) {
            this.camSource.open(this.videoFilePath);
            System.out.println("fps: " + this.camSource.get(5));
        } else {
            this.camSource.open(this.cameraIdx);
        }
        boolean bl = false;
        bl = this.faceDetector.load(this.faceStr);
        bl = this.eyeDetector.load(this.eyeStr);
        bl = this.mouthDetector.load(this.mouthStr);
        bl = this.smileDetector.load(this.mouthStr);
        if (!(this.faceDetector.empty() || this.eyeDetector.empty() || this.mouthDetector.empty() || this.smileDetector.empty())) {
            this.myThread = new DaemonThread();
            Thread thread = new Thread(this.myThread);
            thread.setDaemon(true);
            this.myThread.runnable = true;
            thread.start();
            this.btnStart.setEnabled(false);
            this.btnStop.setEnabled(true);
            this.cbxFaceDetect.setEnabled(true);
            this.cbxEyesDetect.setEnabled(true);
            this.cbxMouthDetect.setEnabled(true);
            this.cbxSmileDetect.setEnabled(true);
            this.lblMessage.setText("Cascade Files load successfully");
        } else {
            this.lblMessage.setText("cannot load Cascade File");
        }
    }

    private void btnStopActionPerformed(ActionEvent actionEvent) {
        this.cbxFaceDetect.setEnabled(false);
        this.cbxEyesDetect.setEnabled(false);
        this.cbxMouthDetect.setEnabled(false);
        this.cbxSmileDetect.setEnabled(false);
        this.myThread.runnable = false;
        this.btnStop.setEnabled(false);
        this.btnStart.setEnabled(true);
        this.cbxFaceDetect.setSelected(false);
        this.cbxEyesDetect.setSelected(false);
        this.cbxMouthDetect.setSelected(false);
        this.faceDetectCbx = false;
        this.eyesDetectCbx = false;
        this.mouthDetectCbx = false;
        this.smileDetectCbx = false;
        this.camSource.release();
    }

    private void cbxFaceDetectActionPerformed(ActionEvent actionEvent) {
        this.faceDetectCbx = this.cbxFaceDetect.isSelected();
    }

    private void cbxEyesDetectActionPerformed(ActionEvent actionEvent) {
        this.eyesDetectCbx = this.cbxEyesDetect.isSelected();
    }

    private void cbxMouthDetectActionPerformed(ActionEvent actionEvent) {
        this.mouthDetectCbx = this.cbxMouthDetect.isSelected();
    }

    private void cbxSmileDetectActionPerformed(ActionEvent actionEvent) {
        if (this.cbxSmileDetect.isSelected()) {
            this.smileDetectCbx = true;
        } else {
            this.smileDetectCbx = false;
            this.lblMessage.setText("");
        }
    }

    private void btnCascadePathActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Select Cascade Path");
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setCurrentDirectory(new File(this.usrDir));
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.cascadePath = jFileChooser.getSelectedFile().getPath();
            this.faceStr = this.cascadePath + "/haarcascade_frontalface_alt_tree.xml";
            this.eyeStr = this.cascadePath + "/haarcascade_eye.xml";
            this.mouthStr = this.cascadePath + "/haarcascade_mcs_mouth.xml";
            this.smileStr = this.cascadePath + "/haarcascade_smile.xml";
            this.lblMessage.setText(this.cascadePath);
            if (this.maxCameras > 0) {
                this.btnStart.setEnabled(true);
            }
            boolean bl = this.writeFile();
        }
    }

    private void labelUrlMouseMoved(MouseEvent mouseEvent) {
        this.labelUrl.setCursor(new Cursor(12));
    }

    private void labelUrlMouseClicked(MouseEvent mouseEvent) {
        try {
            URI uRI = new URI("http://www.power-bits.de");
            JavaFaceDetect.urlOpen(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            System.out.println("Error open Site!");
        }
    }

    private void cbbCamerasActionPerformed(ActionEvent actionEvent) {
        this.cameraIdx = this.cbbCameras.getSelectedIndex();
        this.camSource.release();
        this.camSource.open(this.cameraIdx);
        if (!this.camSource.isOpened()) {
            this.lblCamera.setText("no camera");
        } else {
            this.lblCamera.setText("using camera:");
            this.sourceVideo = false;
            this.sourcePicture = false;
        }
    }

    private void btnVideoFileActionPerformed(ActionEvent actionEvent) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Select Video or Picture");
        jFileChooser.setCurrentDirectory(new File(this.usrDir));
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("image files", ImageIO.getReaderFileSuffixes());
        FileNameExtensionFilter fileNameExtensionFilter2 = new FileNameExtensionFilter("AVI", "avi");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        jFileChooser.addChoosableFileFilter(fileNameExtensionFilter2);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.videoFilePath = jFileChooser.getSelectedFile().getPath();
            string = jFileChooser.getSelectedFile().getName();
            string4 = mimetypesFileTypeMap.getContentType(string);
            this.videoFileExt = string.substring(string.lastIndexOf("."), string.length());
            string2 = string4.substring(0, string4.indexOf("/"));
            string3 = string4.substring(string4.indexOf("/") + 1, string4.length());
            this.lblMessage.setText("load: " + this.videoFilePath);
            System.out.println(this.videoFilePath);
            System.out.println(string4 + " - " + string2 + " " + string3);
            System.out.println(string);
            System.out.println(this.videoFileExt);
            if (string2.equals("image") || string3.equals("octet-stream")) {
                this.sourcePicture = true;
                this.sourceVideo = false;
            } else if (string2.equals("video")) {
                this.sourceVideo = true;
                this.sourcePicture = false;
            }
            this.btnStart.setEnabled(true);
        }
    }

    private void formWindowClosed(WindowEvent windowEvent) {
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        if (this.myThread != null && this.myThread.runnable) {
            this.myThread.runnable = false;
            this.camSource.release();
        }
    }

    public static void main(String[] stringArray) {
        System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
        System.out.println("Welcome to OpenCV " + Core.VERSION);
        String string = "os.arch";
        System.out.println(System.getProperty(string));
        String string2 = "os.name";
        String string3 = "os.version";
        System.out.println("Name of the OS: " + System.getProperty(string2));
        System.out.println("Version of the OS: " + System.getProperty(string3));
        System.out.println("Working Directory = " + System.getProperty("user.dir"));
        try {
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(lookAndFeelInfo.getName())) continue;
                UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(JavaFaceDetect.class.getName()).log(Level.SEVERE, null, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            Logger.getLogger(JavaFaceDetect.class.getName()).log(Level.SEVERE, null, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(JavaFaceDetect.class.getName()).log(Level.SEVERE, null, illegalAccessException);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            Logger.getLogger(JavaFaceDetect.class.getName()).log(Level.SEVERE, null, unsupportedLookAndFeelException);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavaFaceDetect.setDefaultLookAndFeelDecorated(true);
                new JavaFaceDetect().setVisible(true);
            }
        });
    }

    class DaemonThread
    implements Runnable {
        protected volatile boolean runnable = false;

        DaemonThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DaemonThread daemonThread = this;
            synchronized (daemonThread) {
                JavaFaceDetect.this.runApp = this.runnable;
                while (this.runnable) {
                    if (JavaFaceDetect.this.sourcePicture) {
                        JavaFaceDetect.this.frame = Highgui.imread(JavaFaceDetect.this.videoFilePath);
                        if (JavaFaceDetect.this.frame.empty()) continue;
                        JavaFaceDetect.this.detectAndDraw();
                        continue;
                    }
                    JavaFaceDetect.this.detectAndDraw();
                }
            }
        }
    }
}

